CREATE TABLE W83B.W83B11T00 (
       IDNW83B11        INTEGER NOT NULL,
       DNIW83B11        VARCHAR2(10) NOT NULL,
       NOMW83B11        VARCHAR2(50) NULL,
       IDDW83B11        VARCHAR2(17) NOT NULL,
       OILW83B11        INTEGER NOT NULL,
       NDFW83B11        VARCHAR2(29) NULL,
       DENW83B11        NUMBER(1) NULL,
       IDSW83B11        INTEGER NOT NULL,
       INTW83B11        NUMBER(5) NULL,
       CONSTRAINT PK_W83B11T00 PRIMARY KEY(IDNW83B11) USING INDEX TABLESPACE W8302E00
);

COMMENT ON TABLE W83B.W83B11T00 IS 'INFORMACION NOTIFICACIONES';
COMMENT ON COLUMN W83B.W83B11T00.IDNW83B11 IS 'ID DE NOTIFICACION';
COMMENT ON COLUMN W83B.W83B11T00.DNIW83B11 IS 'DNI DE USUARIO';
COMMENT ON COLUMN W83B.W83B11T00.NOMW83B11 IS 'NOMBRE DE USUARIO';
COMMENT ON COLUMN W83B.W83B11T00.IDDW83B11 IS 'ID DE DOKUSI';
COMMENT ON COLUMN W83B.W83B11T00.OILW83B11 IS 'ID DE LOTE';
COMMENT ON COLUMN W83B.W83B11T00.NDFW83B11 IS 'NOMBRE DE FICHERO';
COMMENT ON COLUMN W83B.W83B11T00.DENW83B11 IS 'DIRECCION DE ENVIO';
COMMENT ON COLUMN W83B.W83B11T00.IDSW83B11 IS 'ID USU-SINDICATO';
COMMENT ON COLUMN W83B.W83B11T00.INTW83B11 IS 'INTENTOS';
COMMIT;

CREATE SEQUENCE W83B.W83B11Q00
   START WITH       1
   INCREMENT BY     1
   MINVALUE         1
   NOMAXVALUE
   CACHE            20
   NOCYCLE
   NOORDER
;

CREATE OR REPLACE TRIGGER W83B.TG_W83B11T00_06
BEFORE INSERT  ON W83B.W83B11T00
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
BEGIN
    SELECT W83B.W83B11Q00.NEXTVAL 
    INTO :NEW.IDNW83B11
    FROM DUAL;
END;
/

GRANT ALL ON W83B.W83B11T00 TO w83a;
COMMIT;